<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Blood Donor</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
</head>

<body class="bg-dark text-warning">
    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container-fluid container d-flex justify-content-between ">
            <div class="navbar-brand" href="#">Blood Donor - <?php echo e($donor->name); ?></div>
        </div>
    </nav>

    <div class="container">

        <table class="table table-striped ">
            <thead>
                <tr>
                    <th scope="col">No</th>
                    <th scope="col">Receiver</th>
                    <th scope="col">Donation date</th>
                    <th scope="col">Options</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th scope="row"><?php echo e(++$key); ?></th>
                        <td><?php echo e($donation->receiver); ?></td>
                        <td><?php echo e($donation->created_at->format('d-m-Y')); ?></td>
                        <td>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#edit<?php echo e($donation->id); ?>">
                                Edit
                            </button><button type="button" class="btn btn-danger btn-primary" data-bs-toggle="modal"
                                data-bs-target="#delete<?php echo e($donation->id); ?>">
                                Delete
                            </button>
                        </td>
                    </tr>

                    <!-- Modal -->
                    <div class="modal fade text-dark" id="edit<?php echo e($donation->id); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalLabel">Edit</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('transition.update', $donation->id)); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('patch'); ?>
                                        <div class="mb-3">
                                            <label class="form-label">Date</label>
                                            <input type="date" name="created_at" value="<?php echo e($donation->created_at); ?>"
                                                required>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Receiver</label>
                                            <input class="form-control" value="<?php echo e($donation->receiver); ?>"
                                                name="receiver" required>
                                        </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Save changes</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal -->
                    <div class="modal fade text-dark" id="delete<?php echo e($donation->id); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalLabel">Delete</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="h3">Are you sure to Delete " <?php echo e($donation->receiver); ?> " ?</div>
                                </div>
                                <div class="modal-footer">

                                    <form action="<?php echo e(route('transition.destroy', $donation->id)); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('delete'); ?>
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-danger">Delete</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo e($donations->links()); ?>


    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz" crossorigin="anonymous">
    </script>
</body>

</html>
<?php /**PATH C:\Users\devel\Workspace\blood\resources\views/view.blade.php ENDPATH**/ ?>